package gov.va.med.mhv.portal.nsoc;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class XSSEncodingFilter implements Filter{
	private static final Log LOG = LogFactory.getLog(XSSEncodingFilter.class);

	private static String xssMode = null;

	public void destroy() {
		// TODO Auto-generated method stub

	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		chain.doFilter(EncodingFilterFactory.getRequestWrapper(request, xssMode), response);
	}

	public void init(FilterConfig config) throws ServletException {
		/*
		 * none - no xss.
		 * url - check only url parameters.
		 * all - check all parameters.
		 */
		xssMode = config.getInitParameter("xss-mode");
		if(null==xssMode){
			xssMode = "none";
		}
		if( LOG.isInfoEnabled() ) {
			LOG.info("\nXSSEncodingFilter Initialized with XSS_MODE=" + xssMode);
		}
	}

}
